#pragma once

#include <yandex_io/modules/demo_mode/demo_listener_interface/i_demo_mode_listener.h>
#include <yandex_io/modules/demo_mode/demo_provider_interface/i_demo_provider.h>

#include <yandex_io/modules/voice_assistant_blocker/voice_assistant_blocker.h>

#include <yandex_io/libs/base/named_callback_queue.h>
#include <yandex_io/sdk/sdk_interface.h>
#include <yandex_io/sdk/sound_command_observer.h>

#include <deque>
#include <list>
#include <memory>
#include <mutex>

class DemoModeHandler: public YandexIO::SoundCommandObserver {
public:
    DemoModeHandler(std::shared_ptr<IDemoProvider> provider,
                    std::shared_ptr<YandexIO::SDKInterface> sdk,
                    std::string demoModePath);
    ~DemoModeHandler();

public:
    void togglePlay();
    void play();
    void pause();

    bool isDemoMode() const;

    void addListener(std::weak_ptr<IDemoModeListener> listener);

protected:
    void onCommand(std::string_view command) override;

private:
    void scheduleItemsToPlay();
    void onItemFinished();

    void toggleDemoMode();

    void playItem();
    void stopItem();

    std::list<std::weak_ptr<IDemoModeListener>> getListeners();

    void notifyDemoModeStart();
    void notifyDemoModeEnd();
    void notifyDemoModeItemPlaying(const DemoItem& item);
    void notifyDemoModeItemFinished(const DemoItem& item, bool /*pendingStories*/);
    bool onListenerAdded(std::weak_ptr<IDemoModeListener> wlistener) const;

private:
    const std::shared_ptr<IDemoProvider> provider_;
    const std::shared_ptr<YandexIO::SDKInterface> sdk_;

    YandexIO::VoiceAssistantBlocker blocker_;

    const std::string demoModePath_;
    std::atomic<bool> isDemoMode_;

    std::list<std::weak_ptr<IDemoModeListener>> listeners_;
    // protects addListener / notify race
    std::mutex listenersMutex_;

    std::string playingItem_;
    std::deque<DemoItem> items_;

    quasar::Lifetime lifetime_;
    std::shared_ptr<quasar::NamedCallbackQueue> callbackQueue_;

    const std::shared_ptr<YandexIO::IPlaySoundFileListener> playSoundFileListener_;
};
