#pragma once

#include <yandex_io/modules/demo_mode/demo_listener_interface/i_demo_mode_listener.h>

#include <atomic>

class DemoModeStatusListener: public IDemoModeListener {
public:
    void onDemoModeStart() override;
    void onDemoModeEnd() override;

    void onDemoModeItemPlaying(const DemoItem& /*items*/) override;
    void onDemoModeItemFinished(const DemoItem& /*items*/, bool /*pendingStories*/) override;

    void onDemoError() override;
    void onDemoReady() override;

    bool isInDemoMode() const;

private:
    std::atomic<bool> isInDemoMode_{false};
};
