#pragma once

#include <yandex_io/modules/demo_mode/demo_item/demo_item.h>

#include <deque>
#include <optional>

class IDemoProvider {
public:
    virtual ~IDemoProvider();

    virtual std::deque<DemoItem> getAllDemoItems() const = 0;
    virtual std::deque<DemoItem> getNextDemoItems() = 0;
    virtual std::optional<std::chrono::milliseconds> getPauseBetweenItems() const = 0;
    virtual void updateDemoItems(const Json::Value& items) = 0;
    virtual Json::Value toJson() const = 0;
    virtual void prepareItems() = 0;
};
