#include "alice_speaking_demo_mode_led_handler.h"

#include <yandex_io/modules/leds/led_manager/ng/default_animation_conductor.h>

#include <util/system/yassert.h>

AliceSpeakingDemoModeLedHandler::AliceSpeakingDemoModeLedHandler(std::shared_ptr<quasar::LedManager> ledManager)
    : ledManager_(std::move(ledManager))
{
    Y_VERIFY(ledManager_.get() != nullptr);
}

void AliceSpeakingDemoModeLedHandler::onDemoModeItemPlaying(const DemoItem& /*items*/) {
    auto pattern = ledManager_->getPattern("speaking.led");
    ledManager_->play(std::make_shared<DefaultAnimationConductor>(std::move(pattern)));
}

void AliceSpeakingDemoModeLedHandler::onDemoModeItemFinished(const DemoItem& /*items*/, bool /*pendingStories*/) {
    auto pattern = ledManager_->getIdlePattern();
    ledManager_->play(std::make_shared<DefaultAnimationConductor>(std::move(pattern)));
}

void AliceSpeakingDemoModeLedHandler::onDemoModeStart() {
}

void AliceSpeakingDemoModeLedHandler::onDemoModeEnd() {
}

void AliceSpeakingDemoModeLedHandler::onDemoError() {
}

void AliceSpeakingDemoModeLedHandler::onDemoReady() {
}
