#include "demo_mode_led_handler.h"

#include <yandex_io/modules/leds/led_manager/ng/default_animation_conductor.h>

DemoModeLedHandler::DemoModeLedHandler(std::shared_ptr<quasar::LedManager> ledManager)
    : ledManager_(std::move(ledManager))
{
}

void DemoModeLedHandler::onDemoReady() {
    auto pattern = ledManager_->getPattern("demo_ready.led");
    ledManager_->play(std::make_shared<DefaultAnimationConductor>(std::move(pattern), SubstitutionType::FOREGROUND));
}

void DemoModeLedHandler::onDemoError() {
    auto pattern = ledManager_->getPattern("error.led");
    pattern->setDuration(3000);
    ledManager_->play(std::make_shared<DefaultAnimationConductor>(std::move(pattern), SubstitutionType::FOREGROUND));
}

void DemoModeLedHandler::onDemoModeItemPlaying(const DemoItem& /*items*/) {
    auto pattern = ledManager_->getPattern("speaking.led");
    ledManager_->play(std::make_shared<DefaultAnimationConductor>(std::move(pattern)));
}

void DemoModeLedHandler::onDemoModeItemFinished(const DemoItem& /*items*/, bool /*pendingStories*/) {
    auto pattern = ledManager_->getIdlePattern();
    ledManager_->play(std::make_shared<DefaultAnimationConductor>(std::move(pattern)));
}

void DemoModeLedHandler::onDemoModeStart() {
}

void DemoModeLedHandler::onDemoModeEnd() {
}
