#pragma once

#include <yandex_io/modules/demo_mode/demo_listener_interface/i_demo_mode_listener.h>

#include <yandex_io/modules/leds/led_manager/led_manager.h>

class DemoModeLedHandler: public IDemoModeListener {
public:
    explicit DemoModeLedHandler(std::shared_ptr<quasar::LedManager> ledManager);
    ~DemoModeLedHandler() = default;

    void onDemoModeStart() override;
    void onDemoModeEnd() override;

    void onDemoModeItemPlaying(const DemoItem& /*items*/) override;
    void onDemoModeItemFinished(const DemoItem& /*items*/, bool /*pendingStories*/) override;

    void onDemoError() override;
    void onDemoReady() override;

protected:
    const std::shared_ptr<quasar::LedManager> ledManager_;
};
