#include "single_item_provider.h"

#include <yandex_io/libs/logging/logging.h>

SingleItemProvider::SingleItemProvider(const std::string& cachePath, const std::string& itemUrl)
    : item_(cachePath, itemUrl)
{
}

std::deque<DemoItem> SingleItemProvider::getAllDemoItems() const {
    return {item_};
}

std::deque<DemoItem> SingleItemProvider::getNextDemoItems() {
    return {item_};
}

void SingleItemProvider::updateDemoItems(const Json::Value& items) {
    if (!items.isString()) {
        YIO_LOG_INFO("Value must be string");
    }
    item_.sound.url = items.asString();
}

Json::Value SingleItemProvider::toJson() const {
    return Json::Value(item_.sound.url);
}
