#pragma once

#include <yandex_io/modules/demo_mode/demo_provider_interface/i_demo_provider.h>

class SingleItemProvider: public IDemoProvider {
public:
    SingleItemProvider(const std::string& cachePath, const std::string& itemUrl);

    std::deque<DemoItem> getAllDemoItems() const override;
    std::deque<DemoItem> getNextDemoItems() override;
    void updateDemoItems(const Json::Value& items) override;
    Json::Value toJson() const override;
    std::optional<std::chrono::milliseconds> getPauseBetweenItems() const override {
        return std::nullopt;
    }
    void prepareItems() override {
    }

private:
    DemoItem item_;
};
