#include "story_block.h"

#include <yandex_io/libs/json_utils/json_utils.h>

using namespace quasar;

StoryBlock::StoryBlock(const std::string& cachePath, const Json::Value& blockConfig)
    : blockSize_(tryGetInt(blockConfig, "blockSize", 0))
{
    if (blockConfig.isMember("stories") && blockConfig["stories"].isArray()) {
        for (const auto& item : blockConfig["stories"]) {
            stories_.push_back(DemoItem(cachePath, tryGetString(item, "sound"), tryGetJson(item, "animation")));
        }
    }
    it_ = stories_.begin();
}

Json::Value StoryBlock::toJson() const {
    Json::Value result;
    result["blockSize"] = blockSize_;
    for (const auto& item : stories_) {
        result["stories"].append(item.toJson());
    }
    return result;
}

std::deque<DemoItem> StoryBlock::getAllDemoItems() const {
    return stories_;
}

std::deque<DemoItem> StoryBlock::getNextDemoItems() {
    std::deque<DemoItem> result;
    if (stories_.empty()) {
        return result;
    }

    for (int i = 0; i < blockSize_; i++) {
        if (it_ == stories_.end()) {
            it_ = stories_.begin();
        }
        const auto& item = *it_++;
        result.push_back(item);
    }
    return result;
}
