#include "story_module.h"

StoryModule::StoryModule(const std::string& cachePath, const Json::Value& modulesArray)
    : cachePath_(cachePath)
{
    if (modulesArray.isArray()) {
        for (const auto& item : modulesArray) {
            blocks_.push_back(StoryBlock(cachePath, item));
        }
    }
}

Json::Value StoryModule::toJson() const {
    Json::Value result;
    for (const auto& block : blocks_) {
        result.append(block.toJson());
    }
    return result;
}

std::deque<DemoItem> StoryModule::getAllDemoItems() const {
    std::deque<DemoItem> result;
    for (const auto& block : blocks_) {
        const auto stories = block.getAllDemoItems();
        for (const auto& story : stories) {
            result.push_back(story);
        }
    }
    return result;
}

std::deque<DemoItem> StoryModule::getNextDemoItems() {
    std::deque<DemoItem> result;
    for (auto& block : blocks_) {
        const auto stories = block.getNextDemoItems();
        for (const auto& story : stories) {
            result.push_back(story);
        }
    }
    return result;
}

void StoryModule::updateDemoItems(const Json::Value& items) {
    blocks_.clear();
    if (items.isArray()) {
        for (const auto& item : items) {
            blocks_.push_back(StoryBlock(cachePath_, item));
        }
    }
}
