#pragma once

#include "story_block.h"

#include <yandex_io/modules/demo_mode/demo_provider_interface/i_demo_provider.h>

#include <json/json.h>

#include <deque>

class StoryModule: public IDemoProvider {
public:
    StoryModule(const std::string& cachePath, const Json::Value& modulesArray);
    Json::Value toJson() const override;
    std::deque<DemoItem> getAllDemoItems() const override;
    std::deque<DemoItem> getNextDemoItems() override;
    void updateDemoItems(const Json::Value& items) override;
    std::optional<std::chrono::milliseconds> getPauseBetweenItems() const override {
        return std::nullopt;
    }
    void prepareItems() override {
    }

private:
    std::deque<StoryBlock> blocks_;
    const std::string cachePath_;
};
