#pragma once

#include <yandex_io/sdk/sdk_state.h>

#include <optional>

namespace YandexIO {

    struct ExtendedDeviceState {
        YandexIO::SDKState sdkState;

        enum class DataResetState {
            DATA_RESET_WAIT_CONFIRM,
            DATA_RESET_IN_PROGRESS,
            NONE
        };

        std::optional<DataResetState> dataResetState;

        std::optional<bool> isMicOn;

        struct BluetoothStreamInState {
            bool isConnected{false};
            bool isPlaying{false};
            bool isDiscoverable{false};
        };

        std::optional<BluetoothStreamInState> bluetoothStreamInState;

        enum class SuggestedLedAnimation {
            IDLE,
            MUTE,
            BLUETOOTH_IS_PLAYING,
            LISTENING,
            SPEAKING,
            THINKING,
            SHAZAM,
            ALARM,
            TIMER,
            TIMER_COUNTDOWN,
            DATA_RESET_WAIT_CONFIRM,
            DATA_RESET_IN_PROGRESS,
            CONFIGURING,
            CONFIGURED,
            UPDATE_DOWNLOADING,
            UPDATE_APPLYING,
            NOTIFICATION_AVAILABLE,
            NOTIFICATION_PASSIVE,
            CALL_RINGING_INCOMING,
            CALL_RINGING_OUTGOING,
            CALL_CONNECTING,
            CALL_CONNECTED,
            CALL_ENDED_OK,
            CALL_ENDED_FAILURE,
            IOT_DISCOVERY_IN_PROGRESS,
            AUDIO_PLAYING,
            MULTIROOM_CLOCK_IS_SYNCHRONIZING1,
            MULTIROOM_CLOCK_IS_SYNCHRONIZING2,
            FOREGROUND_ACTIVITY,
            BLUETOOTH_DISCOVERY
        };

        bool isMediaPlaying() const;
        bool isBluetoothPlaying() const;

        static std::string aliceStateToString(YandexIO::SDKState::AliceState aliceState);
        static std::string configurationStateToString(YandexIO::SDKState::ConfigurationState configurationState);
        static std::string updateStateToString(YandexIO::SDKState::UpdateState updateState);
        static std::string dataResetStateToString(DataResetState dataResetState);
    };

    ExtendedDeviceState::SuggestedLedAnimation computeSuggestedLedAnimation(const ExtendedDeviceState& deviceState);

} // namespace YandexIO
