#pragma once

#include <yandex_io/libs/equalizer_config/equalizer_config.h>

#include <vector>

namespace YandexIO {

    class EqualizerDispatcher {
    public:
        virtual ~EqualizerDispatcher();

        virtual void setUserConfig(EqualizerConfig config) = 0;
        virtual void setSmartConfig(EqualizerConfig config);

        struct Band {
            double freq{0.};
            double width{0.};
        };
        using BandsConfiguration = std::vector<Band>;
        // empty bands means adjustable configuration
        virtual BandsConfiguration getFixedBandsConfiguration() const = 0;
    };

} // namespace YandexIO
