#include "equalizer_dispatcher_factory.h"

#include <sstream>
#include <stdexcept>

namespace YandexIO {

    IEqualizerDispatcherFactory::~IEqualizerDispatcherFactory() = default;

    EqualizerDispatcherFactory::EqualizerDispatcherPtr EqualizerDispatcherFactory::createDispatcher(
        const std::string& type)
    {
        if (auto it = factory_.find(type); it != factory_.end()) {
            return it->second();
        } else {
            throw std::runtime_error("Can't create equalizer dispatcher. Unknown type: " + type);
        }
    }

    void EqualizerDispatcherFactory::addDispatcherType(const std::string& type, CreateDispatcherFunc func) {
        const auto res = factory_.insert({type, std::move(func)});
        if (!res.second) {
            std::stringstream ss;
            ss << "Can't add \"" << type << "\" dispatcherType. Already added";
            throw std::runtime_error(ss.str());
        }
    }

} /* namespace YandexIO */
