#pragma once

#include <yandex_io/modules/equalizer_controller/dispatcher/equalizer_dispatcher.h>

#include <functional>
#include <map>
#include <memory>
#include <string>

namespace YandexIO {

    class IEqualizerDispatcherFactory {
    public:
        using EqualizerDispatcherPtr = std::unique_ptr<EqualizerDispatcher>;
        using CreateDispatcherFunc = std::function<EqualizerDispatcherPtr()>;

        virtual ~IEqualizerDispatcherFactory();

        [[nodiscard]] virtual EqualizerDispatcherPtr createDispatcher(const std::string& type) = 0;
    };

    class EqualizerDispatcherFactory: public IEqualizerDispatcherFactory {
    public:
        [[nodiscard]] EqualizerDispatcherPtr createDispatcher(const std::string& type) override;

        void addDispatcherType(const std::string& type, CreateDispatcherFunc func);

    private:
        std::map<std::string, CreateDispatcherFunc> factory_;
    };

} // namespace YandexIO
