#include "gstreamer_equalizer_dispatcher.h"

namespace {

    std::optional<YandexIO::EqualizerInfo::Band::Type> convertBandType(YandexIO::EqualizerConfig::Band::Type bandType) {
        switch (bandType) {
            case YandexIO::EqualizerConfig::Band::Type::PEAK:
                return YandexIO::EqualizerInfo::Band::Type::PEAK;
            case YandexIO::EqualizerConfig::Band::Type::LOW_SHELF:
                return YandexIO::EqualizerInfo::Band::Type::LOW_SHELF;
            case YandexIO::EqualizerConfig::Band::Type::HIGH_SHELF:
                return YandexIO::EqualizerInfo::Band::Type::HIGH_SHELF;
        }
    }

    YandexIO::EqualizerInfo convertToSdkEqualizer(const YandexIO::EqualizerConfig& equalizerConfig) {
        YandexIO::EqualizerInfo info;
        info.preventClipping = equalizerConfig.preventClipping;
        for (const auto& band : equalizerConfig.bands) {
            info.bands.push_back(YandexIO::EqualizerInfo::Band{
                .freq = band.freq,
                .width = band.width,
                .gain = band.gain,
                .type = band.type.has_value() ? convertBandType(band.type.value()) : std::nullopt});
        }
        return info;
    }

} // namespace

namespace YandexIO {

    GStreamerEqualizerDispatcher::GStreamerEqualizerDispatcher(std::weak_ptr<SDKInterface> sdk)
        : sdk_(std::move(sdk))
    {
    }

    void GStreamerEqualizerDispatcher::setUserConfig(EqualizerConfig config) {
        setConfig(config);
    }

    void GStreamerEqualizerDispatcher::setSmartConfig(EqualizerConfig config) {
        setConfig(config);
    }

    EqualizerDispatcher::BandsConfiguration GStreamerEqualizerDispatcher::getFixedBandsConfiguration() const {
        return {};
    }

    void GStreamerEqualizerDispatcher::setConfig(EqualizerConfig config) {
        if (auto sdk = sdk_.lock()) {
            sdk->setEqualizerConfig(convertToSdkEqualizer(config));
        }
    }

} // namespace YandexIO
