#include "equalizer_stats.h"

namespace YandexIO {

    namespace {
        constexpr int ENTRY_COUNT_TO_SEND = 10;
    } // namespace

    EqualizerStats::EqualizerStats() {
        entries_.reserve(ENTRY_COUNT_TO_SEND);
    }

    void EqualizerStats::onSmartConfig(const EqualizerConfig& config, const SmartEqualizer::Rms& rms) {
        entries_.push_back(Entry{
            .ts = std::chrono::system_clock::now(),
            .config = config,
            .rms = rms});
    }

    bool EqualizerStats::isEnoughDataToSend() const {
        return entries_.size() >= ENTRY_COUNT_TO_SEND;
    }

    Json::Value EqualizerStats::formatJson() const {
        Json::Value result;
        auto& jsonEntries = result["entries"];
        for (const auto& entry : entries_) {
            Json::Value jsonEntry;
            jsonEntry["ts"] = static_cast<uint64_t>(
                std::chrono::duration_cast<std::chrono::milliseconds>(entry.ts.time_since_epoch()).count());
            jsonEntry["config"] = entry.config.toJson();
            jsonEntry["micRms"] = entry.rms.mic;
            jsonEntry["feedbackRms"] = entry.rms.feedback;
            jsonEntries.append(std::move(jsonEntry));
        }
        return result;
    }

    void EqualizerStats::reset() {
        entries_.clear();
    }

} // namespace YandexIO
