#pragma once

#include <yandex_io/libs/equalizer_config/equalizer_config.h>
#include <yandex_io/modules/audio_input/smart_equalizer/smart_equalizer.h>

#include <json/json.h>

#include <chrono>

namespace YandexIO {

    class EqualizerStats {
    public:
        EqualizerStats();
        void onSmartConfig(const EqualizerConfig& config, const SmartEqualizer::Rms& rms);
        bool isEnoughDataToSend() const;
        Json::Value formatJson() const;
        void reset();

    private:
        struct Entry {
            std::chrono::time_point<std::chrono::system_clock> ts;
            EqualizerConfig config;
            SmartEqualizer::Rms rms;
        };
        std::vector<Entry> entries_;
    };

} // namespace YandexIO
