#pragma once

#include <yandex_io/modules/geolocation/interfaces/location.h>
#include <yandex_io/modules/geolocation/interfaces/timezone.h>

#include <util/folder/path.h>

#include <optional>

namespace YandexIO {

    class GeolocationBackup {
    public:
        GeolocationBackup(
            const TFsPath& backupLocationPath,
            const TFsPath& backupTimezonePath);

        std::optional<Location> loadLocation() const;
        std::optional<Timezone> loadTimezone() const;

        void saveLocation(const Location& location) const;
        void saveTimezone(const Timezone& timezone) const;

    private:
        const TFsPath backupLocationPath_;
        const TFsPath backupTimezonePath_;
    };

} // namespace YandexIO
