#include "geo_ipc_server.h"

using namespace quasar;
using namespace YandexIO;

namespace {

    constexpr auto SERVER_NAME = "locationd";

} // anonymous namespace

GeoIpcServer::GeoIpcServer(const std::shared_ptr<ipc::IIpcFactory>& ipcFactory)
    : server_{ipcFactory->createIpcServer(SERVER_NAME)}
{
    server_->setClientConnectedHandler([this](auto& connection) {
        connection.send(createQuasarMessage());
    });
    server_->listenService();
}

void GeoIpcServer::onLocationChanged(const Location& location) {
    {
        std::scoped_lock guard(mutex_);
        location_ = location;
    }
    server_->sendToAll(createQuasarMessage());
}

void GeoIpcServer::onTimezoneChanged(const Timezone& timezone) {
    {
        std::scoped_lock guard(mutex_);
        timezone_ = timezone;
    }
    server_->sendToAll(createQuasarMessage());
}

ipc::SharedMessage GeoIpcServer::createQuasarMessage() const {
    return ipc::buildMessage([this](auto& msg) {
        std::scoped_lock guard(mutex_);
        msg.mutable_current_location()->CopyFrom(location_.toProto());
        msg.mutable_current_timezone()->CopyFrom(timezone_.toProto());
    });
}
