#pragma once

#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/ipc/message.h>
#include <yandex_io/modules/geolocation/geolocation.h>
#include <yandex_io/modules/geolocation/interfaces/location.h>
#include <yandex_io/modules/geolocation/interfaces/timezone.h>

#include <mutex>
#include <string>

namespace YandexIO {

    class GeoIpcServer: public Geolocation::IListener {
    public:
        explicit GeoIpcServer(const std::shared_ptr<quasar::ipc::IIpcFactory>& ipcFactory);

        void onLocationChanged(const Location& location) override;

        void onTimezoneChanged(const Timezone& timezone) override;

    private:
        quasar::ipc::SharedMessage createQuasarMessage() const;

    private:
        const std::shared_ptr<quasar::ipc::IServer> server_;
        mutable std::mutex mutex_;

        Location location_;
        Timezone timezone_;
    };

} // namespace YandexIO
