#include "geo_sdk_setter.h"

using namespace YandexIO;

GeoSDKSetter::GeoSDKSetter(std::shared_ptr<SDKInterface> sdk)
    : sdk_(std::move(sdk))
{
}

void GeoSDKSetter::onLocationChanged(const Location& location) {
    sdk_->setLocation(location.latitude, location.longitude, location.precision);
}

void GeoSDKSetter::onTimezoneChanged(const Timezone& timezone) {
    sdk_->setTimezone(timezone.timezoneName, timezone.timezoneOffsetSec);
}
