#pragma once

#include <yandex_io/libs/http_client/i_http_client.h>
#include <yandex_io/libs/threading/i_callback_queue.h>
#include <yandex_io/libs/threading/lifetime.h>
#include <yandex_io/libs/threading/unique_callback.h>
#include <yandex_io/modules/geolocation/interfaces/location.h>
#include <yandex_io/modules/geolocation/interfaces/timezone.h>
#include <yandex_io/modules/geolocation/backup/geolocation_backup.h>
#include <yandex_io/modules/geolocation/providers/geolocation_config_provider.h>
#include <yandex_io/modules/geolocation/providers/lbs_provider.h>
#include <yandex_io/modules/geolocation/providers/timezone_provider.h>
#include <yandex_io/sdk/sdk_interface.h>
#include <yandex_io/sdk/sdk_state.h>
#include <yandex_io/sdk/backend_config_observer.h>
#include <yandex_io/sdk/sdk_state_observer.h>
#include <yandex_io/sdk/wifi_info.h>

#include <util/folder/path.h>

#include <chrono>
#include <memory>
#include <string>
#include <vector>

namespace YandexIO {

    class Geolocation: public SDKStateObserver, public BackendConfigObserver {
    public:
        class IListener {
        public:
            virtual void onLocationChanged(const Location& location) = 0;
            virtual void onTimezoneChanged(const Timezone& timezone) = 0;

            virtual ~IListener() = default;
        };

        struct Settings {
            std::string deviceType;
            std::string deviceId;
            std::string lbsBackendUrl;
            std::string quasarBackendUrl;
            TFsPath backupLocationPath;
            TFsPath backupTimezonePath;
            std::chrono::seconds baseScheduleTime = std::chrono::hours(1);
            std::chrono::seconds errorScheduleTime = std::chrono::minutes(1);
        };

        static std::shared_ptr<Geolocation> create(
            std::shared_ptr<SDKInterface> sdk,
            std::shared_ptr<quasar::ICallbackQueue> callbackQueue,
            std::shared_ptr<quasar::IHttpClient> httpClient,
            const Settings& settings);

        Geolocation(
            std::shared_ptr<quasar::ICallbackQueue> callbackQueue,
            std::shared_ptr<quasar::IHttpClient> httpClient,
            const Settings& settings);
        ~Geolocation();

        void onSDKState(const SDKState& state) override;

        void onSystemConfig(const std::string& configName, const std::string& jsonConfigValue) override;
        void onDeviceConfig(const std::string& configName, const std::string& jsonConfigValue) override;

        void addListener(std::weak_ptr<IListener> listener);

    private:
        enum class UpdateStatus {
            SUCCESS,
            FAILED,
        };

        UpdateStatus update();
        void schedulePeriodicUpdate(const UpdateStatus& status);

        void notifyLocationChanged(const std::weak_ptr<IListener>& wlistener, const Location& location) const;
        void notifyTimezoneChanged(const std::weak_ptr<IListener>& wlistener, const Timezone& timezone) const;
        void notifyAllListeners(const Location& location, const Timezone& timezone) const;

    private:
        const std::shared_ptr<quasar::ICallbackQueue> callbackQueue_;
        quasar::UniqueCallback uniqueCallback_;
        quasar::Lifetime lifetime_;

        const GeolocationBackup backup_;
        const LbsProvider locationProvider_;
        const TimezoneProvider timezoneProvider_;

        const std::chrono::seconds baseScheduleTime_;
        const std::chrono::seconds errorScheduleTime_;

        // All the values below can be read and written only in callbackQueue_ thread
        GeolocationConfigProvider configProvider_;
        std::vector<std::weak_ptr<IListener>> listeners_;

        std::vector<WifiInfo> wifiList_;
    };

} // namespace YandexIO
