#include "location.h"

#include <yandex_io/libs/json_utils/json_utils.h>
#include <util/string/cast.h>

using namespace quasar;
using namespace YandexIO;

Json::Value Location::toJson() const {
    Json::Value location;

    location["latitude"] = latitude;
    location["longitude"] = longitude;
    if (precision.has_value()) {
        location["precision"] = *precision;
    }

    return location;
}

proto::Location Location::toProto() const {
    proto::Location location;

    location.set_latitude(latitude);
    location.set_longitude(longitude);
    if (precision.has_value()) {
        location.set_precision(*precision);
    }

    return location;
}

std::optional<Location> Location::fromJson(const Json::Value& json) {
    if (!json["longitude"].isDouble() || !json["latitude"].isDouble()) {
        return std::nullopt;
    }

    if (json["precision"].isDouble()) {
        return {{.latitude = getDouble(json, "latitude"),
                 .longitude = getDouble(json, "longitude"),
                 .precision = getDouble(json, "precision")}};
    }

    return {{.latitude = getDouble(json, "latitude"),
             .longitude = getDouble(json, "longitude")}};
}

Location Location::fromProto(const proto::Location& location) {
    Y_ENSURE(location.has_latitude() && location.has_longitude());

    if (location.has_precision()) {
        return {.latitude = location.latitude(),
                .longitude = location.longitude(),
                .precision = location.precision()};
    }

    return {.latitude = location.latitude(),
            .longitude = location.longitude()};
}

std::ostream& operator<<(std::ostream& os, const Location& location) {
    return os << "(" << location.latitude << ", " << location.longitude << ")";
}
