#pragma once

#include <yandex_io/protos/model_objects.pb.h>

#include <json/json.h>
#include <optional>
#include <ostream>

namespace YandexIO {

    struct Location {
        double latitude;
        double longitude;
        std::optional<double> precision = std::nullopt;

        auto operator<=>(const Location&) const = default;

        Json::Value toJson() const;
        quasar::proto::Location toProto() const;

        static std::optional<Location> fromJson(const Json::Value& json);
        static Location fromProto(const quasar::proto::Location& location);
    };

} // namespace YandexIO

std::ostream& operator<<(std::ostream& os, const YandexIO::Location& location);
