#include "timezone.h"

#include <yandex_io/libs/json_utils/json_utils.h>
#include <util/string/cast.h>

using namespace quasar;
using namespace YandexIO;

Json::Value Timezone::toJson() const {
    Json::Value timezone;
    timezone["timezone_name"] = timezoneName;
    timezone["offset_sec"] = timezoneOffsetSec;
    return timezone;
}

proto::Timezone Timezone::toProto() const {
    proto::Timezone timezone;
    timezone.set_timezone_name(TString(timezoneName));
    timezone.set_timezone_offset_sec(static_cast<int32_t>(timezoneOffsetSec));
    return timezone;
}

std::optional<Timezone> Timezone::fromJson(const Json::Value& json) {
    if (!json["timezone_name"].isString() || !json["offset_sec"].isInt64()) {
        return std::nullopt;
    }

    return {{.timezoneName = getString(json, "timezone_name"),
             .timezoneOffsetSec = getInt64(json, "offset_sec")}};
}

Timezone Timezone::fromProto(const proto::Timezone& timezone) {
    Y_ENSURE(timezone.has_timezone_name() && timezone.has_timezone_offset_sec());

    return {.timezoneName = timezone.timezone_name(),
            .timezoneOffsetSec = timezone.timezone_offset_sec()};
}

std::ostream& operator<<(std::ostream& os, const Timezone& timezone) {
    return os << timezone.timezoneName << " (" << timezone.timezoneOffsetSec << " sec)";
}
