#pragma once

#include <yandex_io/protos/model_objects.pb.h>

#include <json/json.h>
#include <string>
#include <optional>
#include <ostream>

namespace YandexIO {

    struct Timezone {
        std::string timezoneName;
        int64_t timezoneOffsetSec;

        std::strong_ordering operator<=>(const Timezone&) const = default;

        Json::Value toJson() const;
        quasar::proto::Timezone toProto() const;

        static std::optional<Timezone> fromJson(const Json::Value& json);
        static Timezone fromProto(const quasar::proto::Timezone& timezone);
    };

} // namespace YandexIO

std::ostream& operator<<(std::ostream& os, const YandexIO::Timezone& timezone);
