#pragma once

#include <yandex_io/modules/geolocation/interfaces/location.h>
#include <yandex_io/modules/geolocation/interfaces/timezone.h>
#include <yandex_io/sdk/sdk_interface.h>

#include <memory>
#include <optional>
#include <string>

namespace YandexIO {

    class GeolocationConfigProvider {
    public:
        enum class State {
            HAS_UPDATE,
            NO_UPDATE,
        };

        static void subscribeToConfigUpdate(std::shared_ptr<SDKInterface> sdk);

        State onDeviceConfig(const std::string& configName, const std::string& jsonConfigValue);
        State onSystemConfig(const std::string& configName, const std::string& jsonConfigValue);

        const std::optional<Location>& getLocation() const;
        const std::optional<Timezone>& getTimezone() const;

    private:
        std::optional<Location> locationFromDeviceConfig_;
        std::optional<Location> locationFromSystemConfig_;
        std::optional<Timezone> timezoneFromSystemConfig_;
    };

} // namespace YandexIO
