#include "lbs_provider.h"

#include <yandex_io/libs/base/utils.h>
#include <yandex_io/libs/json_utils/json_utils.h>
#include <yandex_io/libs/logging/logging.h>

#include <sstream>

YIO_DEFINE_LOG_MODULE("geolocation");

using namespace quasar;
using namespace YandexIO;

namespace {

    constexpr auto API_KEY = "APl-5FoBAAAA5eCjSgMAh9tzkRj4lgqd2YxGsIJCOWWxMwIAAAAAAAAAAADwgzUA3HGu26NfXMGgRmswsvfVJQ==";

} // anonymous namespace

LbsProvider::LbsProvider(
    std::shared_ptr<IHttpClient> httpClient,
    const std::string& lbsBackendUrl,
    const std::string& deviceType,
    const std::string& deviceId)
    : httpClient_(std::move(httpClient))
    , lbsBackendUrl_(LbsProvider::buildBackendUrl(lbsBackendUrl, deviceType, deviceId))
{
}

std::optional<Location> LbsProvider::request(const std::vector<WifiInfo>& wifiList) const {
    std::optional<Location> location;

    try {
        const auto requestString = buildRequestString(wifiList);
        YIO_LOG_DEBUG("Request for LBS: " << requestString);

        const auto response = httpClient_->post(
            "geolocation",
            lbsBackendUrl_,
            requestString,
            {{"Content-Type", "application/json"}});

        if (!isSuccessHttpCode(response.responseCode)) {
            std::stringstream ss;
            ss << "Request location: Http connection error. Response code: " << response.responseCode << ". Body: " << response.body;
            throw std::runtime_error(ss.str());
        }

        YIO_LOG_INFO("Got geolocation from LBS: " << response.body);
        const auto responseJson = parseJson(response.body);
        location = Location::fromJson(responseJson["position"]);
    } catch (const std::exception& e) {
        YIO_LOG_WARN(e.what());
    }

    return location;
}

std::string LbsProvider::buildBackendUrl(const std::string& lbsBackendUrl, const std::string& deviceType, const std::string& deviceId) {
    Y_VERIFY(!deviceType.empty());
    Y_VERIFY(!deviceId.empty());
    std::stringstream ss;

    // Set up additional information to LBS url, so it will be more easy to find YandexIO devices in LBS logs
    ss << lbsBackendUrl << "/geolocation?yandex_io_platform=" << deviceType << "&yandex_io_device_id=" << deviceId;
    return ss.str();
}

std::string LbsProvider::buildRequestString(const std::vector<WifiInfo>& wifiList) {
    Json::Value request;

    request["common"]["version"] = "1.0";
    request["common"]["api_key"] = API_KEY;

    for (const auto& wifiInfo : wifiList) {
        Json::Value network;

        network["mac"] = wifiInfo.mac;
        network["signal_strength"] = wifiInfo.rssi;

        request["wifi_networks"].append(network);
    }

    return "json=" + jsonToString(request);
}
