#pragma once

#include <yandex_io/libs/http_client/i_http_client.h>
#include <yandex_io/modules/geolocation/interfaces/location.h>
#include <yandex_io/sdk/wifi_info.h>

#include <memory>
#include <string>
#include <optional>
#include <vector>

namespace YandexIO {

    class LbsProvider {
    public:
        LbsProvider(
            std::shared_ptr<quasar::IHttpClient> client,
            const std::string& lbsBackendUrl,
            const std::string& deviceType,
            const std::string& deviceId);

        std::optional<Location> request(const std::vector<WifiInfo>& wifiList) const;

    private:
        static std::string buildBackendUrl(const std::string& lbsBackendUrl, const std::string& deviceType, const std::string& deviceId);
        static std::string buildRequestString(const std::vector<WifiInfo>& wifiList);

        const std::shared_ptr<quasar::IHttpClient> httpClient_;
        const std::string lbsBackendUrl_;
    };

} // namespace YandexIO
