#pragma once

#include <yandex_io/libs/http_client/i_http_client.h>
#include <yandex_io/modules/geolocation/interfaces/location.h>
#include <yandex_io/modules/geolocation/interfaces/timezone.h>

#include <memory>
#include <string>
#include <optional>

namespace YandexIO {

    class TimezoneProvider {
    public:
        TimezoneProvider(std::shared_ptr<quasar::IHttpClient> httpClient, const std::string& quasarBackendUrl);
        std::optional<Timezone> request(const Location& location) const;

    private:
        std::string buildBackendUrl(const Location& location) const;

        const std::shared_ptr<quasar::IHttpClient> httpClient_;
        const std::string quasarBackendUrl_;
    };

} // namespace YandexIO
