#include "util.h"

#include <yandex_io/libs/base/named_callback_queue.h>
#include <yandex_io/libs/configuration/configuration.h>
#include <yandex_io/libs/http_client/http_client.h>

#include <util/string/cast.h>

using namespace quasar;
using namespace YandexIO;

std::pair<std::shared_ptr<Geolocation>, std::shared_ptr<GeoSDKSetter>> YandexIO::GeolocationUtil::installModule(
    std::shared_ptr<SDKInterface> sdk,
    const std::shared_ptr<IDevice>& device,
    TFsPath backupPath) {
    auto geolocationModule = Geolocation::create(
        sdk,
        std::make_shared<NamedCallbackQueue>("Geolocation"),
        std::make_shared<HttpClient>("geolocation", device),
        Geolocation::Settings({.deviceType = device->platform(),
                               .deviceId = device->deviceId(),
                               .lbsBackendUrl = "https://api.lbs.yandex.net",
                               .quasarBackendUrl = device->configuration()->getBackendUrl(),
                               .backupLocationPath = JoinFsPaths(backupPath, "location.dat"),
                               .backupTimezonePath = JoinFsPaths(backupPath, "timezone.dat")}));
    auto geoSDKSetter = std::make_shared<GeoSDKSetter>(std::move(sdk));
    geolocationModule->addListener(geoSDKSetter);
    return {geolocationModule, geoSDKSetter};
}
