#include "last_update_handler.h"

void LastUpdateHandler::onLastUpdateInfo(bool wasAttempted, bool attemptSucceeded)
{
    {
        std::lock_guard<std::mutex> guard(lastUpdateInfoMutex_);
        receivedLastUpdateInfo_ = true;
        lastUpdateInfo_.wasAttempted = wasAttempted;
        lastUpdateInfo_.attemptSucceeded = attemptSucceeded;
    }
    lastUpdateInfoCondVar_.notify_one();
}

bool LastUpdateHandler::waitLastUpdateInfo(const std::chrono::seconds& timeout)
{
    std::unique_lock<std::mutex> lock(lastUpdateInfoMutex_);
    return lastUpdateInfoCondVar_.wait_for(lock, timeout, [this]() { return receivedLastUpdateInfo_; });
}

LastUpdateHandler::LastUpdateInfo LastUpdateHandler::getLastUpdateInfo() const {
    std::lock_guard<std::mutex> guard(lastUpdateInfoMutex_);
    return lastUpdateInfo_;
}
