#pragma once

#include <yandex_io/libs/threading/steady_condition_variable.h>
#include <yandex_io/sdk/update_observer.h>

#include <chrono>
#include <mutex>

class LastUpdateHandler: public YandexIO::UpdateObserver {
public:
    ~LastUpdateHandler() = default;

    void onLastUpdateInfo(bool wasAttempted, bool attemptSucceeded) override;

    /**
     * @brief wait until received "Last Update Info".
     * @param timeout - how long to wait
     * @return - true - received last update info from YandexIO SDK. false - didn't receive info in timeout
     */
    bool waitLastUpdateInfo(const std::chrono::seconds& timeout);

    struct LastUpdateInfo {
        bool wasAttempted;     /**< Device rebooted because tried to apply update */
        bool attemptSucceeded; /**< Device successfully updated */
    };

    /**
     * @return Return Last Update Info (whether was update, and was updated successfully)
     */
    LastUpdateInfo getLastUpdateInfo() const;

private:
    /**
     * @brief receivedLastUpdateInfo_ is false until first time received UpdateObserver::onLastUpdateInfo evt
     */
    bool receivedLastUpdateInfo_{false};
    LastUpdateInfo lastUpdateInfo_;

    mutable std::mutex lastUpdateInfoMutex_;
    quasar::SteadyConditionVariable lastUpdateInfoCondVar_;
};
