#pragma once

#include <yandex_io/modules/leds/led_manager/led_manager.h>

#include <yandex_io/sdk/sdk_state_observer.h>

#include <memory>

/*
 * @brief When onConversationError happens this class draws "error.led" animation via ledManager
 */
class AliceDialogErrorRenderer final: public YandexIO::SDKStateObserver {
public:
    explicit AliceDialogErrorRenderer(std::shared_ptr<quasar::LedManager> ledManager);
    ~AliceDialogErrorRenderer() = default;

    /**
     * @brief Will call error animation if error happened during conversation
     */
    void onConversationError() override;

    void onSDKState(const YandexIO::SDKState& state) override;

private:
    std::shared_ptr<quasar::LedManager> ledManager_;
};
