#pragma once

#include <yandex_io/modules/leds/led_capability/s3_downloader/s3_downloader.h>
#include <yandex_io/modules/leds/led_capability/scenario_local_animation_loader/i_scenario_local_animation_loader.h>

#include <yandex_io/libs/base/named_callback_queue.h>
#include <yandex_io/libs/device/i_device.h>
#include <yandex_io/sdk/media_observer.h>
#include <yandex_io/sdk/interfaces/i_capability.h>
#include <yandex_io/sdk/interfaces/i_directive_handler.h>
#include <yandex_io/sdk/directive_observer.h>
#include <yandex_io/libs/device/i_device.h>

#include <yandex_io/libs/base/named_callback_queue.h>

#include <alice/protos/endpoint/capability.pb.h>

#include <set>

namespace YandexIO {

    class LedCapability: public ICapability,
                         public IDirectiveHandler,
                         public DirectiveObserver,
                         public std::enable_shared_from_this<LedCapability> {
    public:
        class ILedAnimationListener {
        public:
            ~ILedAnimationListener();
            virtual void onScenarioAnimations(std::vector<std::vector<std::shared_ptr<Animation>>> animations,
                                              NAlice::TAnimationCapability::TDrawAnimationDirective::ESpeakingAnimationPolicy,
                                              NAlice::TAnimationCapability::TDrawAnimationDirective::EAnimationStopPolicy) = 0;
        };

        LedCapability(std::weak_ptr<ILedAnimationListener> listener, const std::vector<NAlice::TAnimationCapability::EFormat>& supportedFormats);
        ~LedCapability();

        void setUpS3Downloader(std::shared_ptr<IAnimationLoader> loader, std::unique_ptr<IFileCache> cache, std::shared_ptr<IDevice> device, const S3Downloader::Params& params);
        void setUpLocalLoader(std::shared_ptr<IScenarioLocalAnimationLoader> localLoader, std::set<std::string> supportedScenarios);

    private:
        // ICapability implementation
        NAlice::TCapabilityHolder getState() const override;
        YandexIO::IDirectiveHandlerPtr getDirectiveHandler() override;
        void addListener(std::weak_ptr<YandexIO::ICapability::IListener> /*wlistener*/) override;
        void removeListener(std::weak_ptr<YandexIO::ICapability::IListener> /*wlistener*/) override;

        static NAlice::TCapabilityHolder createState(const std::vector<NAlice::TAnimationCapability::EFormat>& supportedFormats);

        // IDirectiveHandler implementation
        const std::string& getHandlerName() const override;
        const std::set<std::string>& getSupportedDirectiveNames() const override;
        void handleDirective(const std::shared_ptr<YandexIO::Directive>& directive) override;
        void cancelDirective(const std::shared_ptr<YandexIO::Directive>& directive) override;
        void prefetchDirective(const std::shared_ptr<YandexIO::Directive>& directive) override;

        // Directive observer
        void onDirective(const std::string& name, const std::string& vinsRequestId, const std::string& jsonPayload) override;

        std::vector<std::shared_ptr<Animation>> handleS3Format(const NAlice::TAnimationCapability::TDrawAnimationDirective::TAnimation::TS3Directory& s3Payload);

    private:
        static const std::string DRAW_ANIMATION_DIRECTIVE;

        std::unique_ptr<S3Downloader> downloader_;
        std::shared_ptr<IScenarioLocalAnimationLoader> loader_;
        std::weak_ptr<ILedAnimationListener> listener_;
        std::set<std::string> supportedScenarios_;
        quasar::NamedCallbackQueue queue_{"LedCapability"};

        const NAlice::TCapabilityHolder state_;
    };

} // namespace YandexIO
