#pragma once

#include <string>

namespace YandexIO {

    class IFileCache {
    public:
        struct CacheResult {
            std::string filename;
            bool hit;
        };

        virtual ~IFileCache();
        virtual CacheResult getEntry(const std::string& key) = 0;
        virtual int clear() = 0;
        virtual std::string putEntry(const std::string& key) = 0;
        virtual void invalidateEntry(const std::string& key) = 0;
        virtual void setSizeEntries(uint64_t sizeEntries) = 0;
        virtual void setSizeKbytes(int sizeKbytes) = 0;
    };

} // namespace YandexIO
