#pragma once

#include <yandex_io/modules/leds/led_capability/s3_downloader/cache/i_cache.h>

#include <util/folder/path.h>

#include <list>

namespace YandexIO {

    class PersistentLruCache: public IFileCache {
    public:
        explicit PersistentLruCache(TFsPath cachePath);

        CacheResult getEntry(const std::string& key) override;
        int clear() override;
        std::string putEntry(const std::string& key) override;
        void invalidateEntry(const std::string& key) override;
        void setSizeEntries(uint64_t sizeEntries) override;
        void setSizeKbytes(int sizeKbytes) override;

    private:
        std::string filenameFromUrl(const std::string& url) const;
        void removeFile(const std::string& filename);
        void shrinkToFit();

        auto findInCache(const std::string& filename) const {
            return std::find_if(cache_.begin(), cache_.end(), [&filename](const auto& entry) {
                return entry == filename;
            });
        }

        std::list<std::string> cache_;
        TFsPath cachePath_;
        size_t maxEntries_;
    };

} // namespace YandexIO
