#pragma once

#include <yandex_io/modules/leds/led_capability/s3_downloader/cache/i_cache.h>

#include <yandex_io/modules/leds/led_capability/animation_loader/i_animation_loader.h>

#include <yandex_io/modules/leds/led_manager/ng/animation_composition.h>

#include <yandex_io/libs/http_client/http_client.h>

#include <string>

namespace YandexIO {

    class S3Downloader {
    public:
        struct Params {
            std::string directory;
            std::chrono::milliseconds timeout = std::chrono::seconds{3};
            uint32_t retries = 3;
            std::string name = "s3_animations";
            int cacheSizeKb = 10000;
            uint64_t cacheEntries = 10;
            std::string metaFile = "meta.txt";
        };
        S3Downloader(std::shared_ptr<IAnimationLoader> loader, std::unique_ptr<IFileCache> cache, std::shared_ptr<IDevice> device, const Params& params);

        std::vector<std::shared_ptr<Animation>> getAnimations(const std::string& bucket, const std::string& path);

    private:
        std::vector<std::string> getAnimationDownloadUrls(const std::string& bucketUrl, const std::string& path);
        std::vector<std::string> getAnimationFilenames(const std::vector<std::string>& urls);

    private:
        const std::string directory_;
        const std::string metaFile_;
        const std::shared_ptr<IAnimationLoader> loader_;
        const std::unique_ptr<IFileCache> cache_;
        const std::shared_ptr<IDevice> device_;
        quasar::HttpClient client_;
    };

} // namespace YandexIO
