#include "color_readers.h"

#include <iomanip>
#include <sstream>

using namespace quasar;

namespace {

    uint32_t readHexNumber(const std::string& stringNumber) {
        uint32_t result;
        std::stringstream tmp;

        tmp << std::hex << stringNumber;
        tmp >> result;

        return result;
    }

    uint8_t getNthByte(uint32_t number, int n) {
        return (number >> (8 * n)) & 0xff;
    }

} // namespace

rgbw_color quasar::readRGBColor(const std::string& stringColor) {
    uint32_t code = readHexNumber(stringColor);
    rgbw_color result;

    result.r = getNthByte(code, 2);
    result.g = getNthByte(code, 1);
    result.b = getNthByte(code, 0);

    return result;
}

rgbw_color quasar::readRGBWColor(const std::string& stringColor) {
    uint32_t code = readHexNumber(stringColor);
    rgbw_color result;

    result.r = getNthByte(code, 3);
    result.g = getNthByte(code, 2);
    result.b = getNthByte(code, 1);
    result.w = getNthByte(code, 0);

    return result;
}
