#include "color_util.h"

#include <algorithm>
#include <cmath>

quasar::rgbw_color mixColors(quasar::rgbw_color a, quasar::rgbw_color b, float proportion) {
    quasar::rgbw_color result;

    proportion = std::clamp(proportion, 0.0f, 1.0f);

    result.r = std::round((float)a.r * proportion + (float)b.r * (1 - proportion));
    result.g = std::round((float)a.g * proportion + (float)b.g * (1 - proportion));
    result.b = std::round((float)a.b * proportion + (float)b.b * (1 - proportion));
    result.w = std::round((float)a.w * proportion + (float)b.w * (1 - proportion));

    return result;
}
