#pragma once

#include <cstdint>
#include <vector>

namespace quasar {

    struct rgbw_color {
        rgbw_color() = default;
        rgbw_color(uint8_t r,
                   uint8_t g,
                   uint8_t b,
                   uint8_t w)
            : r(r)
            , g(g)
            , b(b)
            , w(w)
        {
        }

        uint8_t r{0};
        uint8_t g{0};
        uint8_t b{0};
        uint8_t w{0};

        bool operator==(const rgbw_color& other) const {
            return r == other.r &&
                   g == other.g &&
                   b == other.b &&
                   w == other.w;
        }

        bool isBlack() const {
            return r == 0 &&
                   g == 0 &&
                   b == 0 &&
                   w == 0;
        }
    } __attribute__((packed));

    using LedCircle = std::vector<rgbw_color>;

} // namespace quasar
