#pragma once

#include "led_circle.h"
#include "led_device.h"

namespace quasar {

    class LedController: public LedDevice {
    public:
        int getWidth() const override;
        int getHeight() const override;

        void clearFrame() override;

        virtual void drawFrame(const quasar::LedCircle& colors) = 0;
        virtual rgbw_color readColor(const std::string& stringColor) = 0;

        virtual ~LedController() = default;
    };

} // namespace quasar
