#pragma once

#include <atomic>

namespace quasar {

    class LedDevice {
    public:
        virtual ~LedDevice() = default;

        virtual int getWidth() const = 0;

        virtual int getHeight() const = 0;

        virtual int getLedCount() const = 0;

        virtual void clearFrame() = 0;

        void addDroppedFrames(int nFrames);

        int getDroppedFrames();

    private:
        std::atomic<int> droppedFrames_;
    };

} // namespace quasar
