#pragma once

#include "led_animator.h"

#include <yandex_io/modules/leds/led_controller/color_readers.h>
#include <yandex_io/modules/leds/led_controller/led_controller.h>
#include <yandex_io/modules/leds/led_patterns/led_pattern.h>
#include <yandex_io/modules/leds/led_patterns/listening_pattern.h>
#include <yandex_io/modules/leds/led_patterns/progress_pattern.h>

#include <map>
#include <memory>
#include <string>

namespace quasar {

    class VolumePattern;
    class ListeningPattern;

    /**
     * LedManager is a base class that can manage Led Animations. It load animations in constructor and can
     * play animations (once) or schedule them as Background
     * Background animations -- it's animations that should be played until they won't be stopped manually.
     */
    class LedManager {
    public:
        /**
         * @brief Constructor: Load patterns using loadPatterns function.
         * @param ledController - led controller implementation, that can control all leds
         * @param ledPatternsPath - path to directory with patterns. DEPRECATED, use LedPatternStorage
         */
        LedManager(std::shared_ptr<LedDevices> ledDevices, const std::string& ledPatternsPath);
        LedManager(std::shared_ptr<LedDevices> ledDevices, const std::string& ledPatternsPath, std::unique_ptr<LedAnimator> animator);
        virtual ~LedManager() = default;

        virtual void play(std::shared_ptr<AnimationConductor> conductor);

        /**
         * @brief stop playing pattern in foreground
         *
         * Deprecated. Use AnimationConductor
         */
        virtual void stop();

        // FIXME: all get...Pattern are deprecated, use LedPatternStorage
        virtual std::shared_ptr<LedPattern> getPattern(const std::string& name) const;
        virtual std::shared_ptr<ListeningPattern> getListeningPattern(double doaAngle) const;
        std::shared_ptr<VolumePattern> getVolumePattern(double volume, bool looped = false) const;
        std::shared_ptr<ProgressPattern> getProgressPattern() const;
        std::shared_ptr<LedPattern> getIdlePattern() const;

    protected:
        void loadPatterns(const std::string& pathToPatternsDirectory);

    protected:
        std::shared_ptr<LedDevices> ledDevices_;

    private:
        std::map<std::string, std::shared_ptr<LedPattern>> patterns_;
        std::unique_ptr<LedAnimator> animator_;
    };

} /* namespace quasar */
