#include "animation.h"

#include <util/system/yassert.h>

Animation::Animation(std::weak_ptr<quasar::LedDevice> ledDevice)
    : ledDevice_(std::move(ledDevice))
{
    Y_VERIFY(ledDevice_.lock() != nullptr);
}

std::weak_ptr<quasar::LedDevice> Animation::getDevice() {
    return ledDevice_;
}

std::string Animation::getName() const {
    return "<Animation>";
}
