#include "animation_background.h"

#include <yandex_io/libs/logging/logging.h>

bool AnimationBackground::updateTime(AnimationBackground::TimePoint timePoint) {
    backgroundAnimation_->updateTime(timePoint);
    foregroundAnimation_->updateTime(timePoint);

    return false;
}

std::vector<const std::shared_ptr<AnimationComposition>> AnimationBackground::currentCompositions() const {
    if (!foregroundAnimation_->isFinished() && backgroundAnimation_->isFinished()) {
        return foregroundAnimation_->currentCompositions();
    } else if (!backgroundAnimation_->isFinished() && foregroundAnimation_->isFinished()) {
        return backgroundAnimation_->currentCompositions();
    } else if (!backgroundAnimation_->isFinished()) {
        auto result = std::vector<const std::shared_ptr<AnimationComposition>>(foregroundAnimation_->currentCompositions());
        auto backgroundAnimationCompositions = backgroundAnimation_->currentCompositions();
        std::copy(backgroundAnimationCompositions.begin(), backgroundAnimationCompositions.end(),
                  std::back_inserter(result));
        return result;
    }
    return {};
}

void AnimationBackground::setForegroundAnimation(std::shared_ptr<AnimationConductor> animationConductor) {
    foregroundAnimation_->setMainAnimation(std::move(animationConductor));
}

void AnimationBackground::setBackgroundAnimation(std::shared_ptr<AnimationConductor> animationConductor) {
    backgroundAnimation_->setMainAnimation(std::move(animationConductor));
}

void AnimationBackground::setSubstitutionAnimation(std::shared_ptr<AnimationConductor> animationConductor) {
    foregroundAnimation_->setPriorityAnimation(std::move(animationConductor));
}

void AnimationBackground::removeForeground() {
    foregroundAnimation_->setMainAnimation(nullptr);
    foregroundAnimation_->setPriorityAnimation(nullptr);
}

void AnimationBackground::logCurrentCompositions() const {
    std::stringstream stream;
    if (!foregroundAnimation_->isFinished()) {
        for (const auto& foregroundAnimation : foregroundAnimation_->currentCompositions()) {
            for (const auto& animation : foregroundAnimation->getAnimations()) {
                stream << "name: < " << animation->getName() << " >";
            }
        }
        YIO_LOG_DEBUG("current foreground: " << stream.str());
    } else {
        YIO_LOG_DEBUG("current foreground: null");
    }

    stream.str("");
    if (!backgroundAnimation_->isFinished()) {
        for (const auto& backgroundAnimation : backgroundAnimation_->currentCompositions()) {
            for (const auto& animation : backgroundAnimation->getAnimations()) {
                stream << " name: <" << animation->getName() << ">";
            }
        }
        YIO_LOG_DEBUG("current background: " << stream.str());
    } else {
        YIO_LOG_DEBUG("current background: null");
    }
}
