#pragma once

#include "animation_composition.h"
#include "animation_substitution.h"
#include "led_devices.h"

#include <chrono>
#include <memory>
#include <string>

/**
 * Layered composition with two simultaneous animations, with only one visible at a time.
 *
 * Displacement is temporary. All (e.g. frontal and head) animation components are displaced.
 *
 * Should be changed and read under mutex, specifically LedAnimator.structureMutex_
 *
 */
class AnimationBackground final { // TODO AnimationLayers ?
public:
    using TimePoint = std::chrono::time_point<std::chrono::steady_clock, std::chrono::nanoseconds>;

    ~AnimationBackground() = default;

    std::vector<const std::shared_ptr<AnimationComposition>> currentCompositions() const;

    bool updateTime(TimePoint timePoint);

    void setForegroundAnimation(std::shared_ptr<AnimationConductor> animationConductor);

    void setBackgroundAnimation(std::shared_ptr<AnimationConductor> animationConductor);

    // deprecated legacy. Use AnimationConductor
    void removeForeground();

    void logCurrentCompositions() const;

    void setSubstitutionAnimation(std::shared_ptr<AnimationConductor> animationConductor);

private:
    std::unique_ptr<AnimationSubstitution> foregroundAnimation_ = std::make_unique<AnimationSubstitution>();
    std::unique_ptr<AnimationSubstitution> backgroundAnimation_ = std::make_unique<AnimationSubstitution>();
};
