#pragma once

#include "animation_background.h"
#include "animation_composition.h"
#include "led_devices.h"

#include <chrono>
#include <memory>
#include <string>

/**
 * Represents current state of leds system in terms of what animationConductor's are on the screen what are in background and so on
 *
 * At most one animationConductor is "on the screen" and there are three "layers" of background, possibly swapping parts of one animation or another:
 * "Substitution", "foreground" and "background"
 *
 * Changed and read under mutex. Specifically, use LedAnimator.structureMutex_
 */
class AnimationChronology final {
public:
    using TimePoint = std::chrono::time_point<std::chrono::steady_clock, std::chrono::nanoseconds>;

    ~AnimationChronology() = default;

    std::vector<std::shared_ptr<Animation>> getAnimations();

    /**
     * move time forward to point
     * @param timePoint to move to
     */
    void updateTime(TimePoint timePoint);

    bool hasNew() const;

    /**
     * One of main entry points. Inspects parameters of conductor and launches it
     *
     * @param animationConductor to launch
     */
    void playNow(std::shared_ptr<AnimationConductor> animationConductor);

    void resetNew();

    // deprecated legacy. Use AnimationConductor
    void removeForeground();

private:
    bool hasNew_ = false; // flag to wait for in main draw loop

    /**
     * Currently played animation
     */
    std::vector<const std::shared_ptr<AnimationComposition>> currentAnimationCompositions_;

    void shift(std::vector<const std::shared_ptr<AnimationComposition>> /*newCurrentAnimation*/);

    AnimationBackground animationBackground = AnimationBackground();

    static bool differ(const std::vector<const std::shared_ptr<AnimationComposition>>& v1,
                       const std::vector<const std::shared_ptr<AnimationComposition>>& v2);

    void updateCompositions();
};
