#include "animation_composition.h"

#include <yandex_io/libs/logging/logging.h>

AnimationComposition::AnimationComposition(std::vector<std::shared_ptr<Animation>> animationCompositionList, bool looped)
    : animationImagesSources_(std::move(animationCompositionList))
    , looped_(looped)
{
    YIO_LOG_DEBUG("AnimationComposition created, animationCompositionList.size " << animationImagesSources_.size());
}

bool AnimationComposition::isLooped() const {
    return looped_;
}

void AnimationComposition::restartComposition() {
    for (const auto& animationImagesSource : animationImagesSources_) {
        animationImagesSource->resetAnimation();
    }

    std::chrono::steady_clock::time_point restartTime = std::chrono::steady_clock::time_point::min();
    for (const auto& animationImagesSource : animationImagesSources_) {
        auto timePoint = animationImagesSource->getEndOfFrameTimePoint();
        if (timePoint > restartTime) {
            restartTime = timePoint;
        }
    }

    // very subtle: restart every animation from the point in time where last of them the was left
    // - this wastes 0 frames
    // - ensures animation progression at all
    // - ensures that during repeated restarts animation are not out of sync

    for (const auto& animationImagesSource : animationImagesSources_) {
        animationImagesSource->startAnimationFrom(restartTime);
    }
}

std::vector<std::shared_ptr<Animation>> AnimationComposition::getAnimations() {
    return animationImagesSources_;
}
